local PANEL = {};

// init
function PANEL:Init( )
	// hovering?
	self.Hovering = false;

	// submenu.
	self.Submenu = nil;
	
	// label
	self.Label = vgui.Create( "label", self );
	self.Label:SetMouseInputEnabled( false );
	
	// seperator?
	self.Seperator = nil;
	
end

// set text
function PANEL:SetText( txt )
	self.Label:SetText( txt );
	
end

// perform layout.
function PANEL:PerformLayout( )
	// have an image?
	if( self.Icon ) then
		self.Icon:SetPos( 2, 0 );
		self.Icon:SetSize( 16, 16 );	
	
	end
	
	// seperator?
	if( self.Seperator && self.Label:IsVisible() ) then
		self.Label:SetVisible( false );
		
	end
	
	// setup label
	self.Label:SizeToContents( );
	self.Label:SetPos( 26, 8 - self.Label:GetTall() * 0.5 );
	
	// have an expander?
	if( self.Expander ) then
		// position it.
		self.Expander:SetPos( self:GetWide() - 16, 0 );
		self.Expander:SetSize( 16, 16 );
	
	end
		
end

// apply scheme settings
function PANEL:ApplySchemeSettings( )
	self.Label:SetFont( AppFramework:Theme().fonts['text'] );
	self.Label:SetFGColor( AppFramework:Theme().colors['text'] );
	
end

// set icon
function PANEL:SetIcon( mat )
	// create
	if( !self.Icon ) then
		self.Icon = vgui.Create( "ctl_icon", self );
		self.Icon:SetMouseInputEnabled( false );
		
	end
	
	// full texture.
	if( type( mat ) == "string" ) then
		self.Icon:SetMaterial( mat );
		
	// imagelist?
	elseif( type( mat ) == "number" && self:GetParent() && self:GetParent().ImageList ) then
		local texture = self:GetParent().ImageList:Get( mat );
		if( texture ) then
			self.Icon.Material = texture;
			
		end
	
	end
	
end

// setup submenu.
function PANEL:SetSubMenu( menu )
	// create an expander.
	if( !self.Expander ) then
		self.Expander = vgui.Create( "ctl_icon", self );
		self.Expander:SetMouseInputEnabled( false );
		self.Expander:SetMaterial( "icons/silk/16/right_arrow" );
			
	end
	
	// store.
	self.Submenu = menu;
	
end


// paint
function PANEL:Paint( )
	// width height
	local width, height = self:GetSize();
		
	// seperator?
	if( self.Seperator ) then
		// seperator.
		local color = AppFramework:Theme().colors['border_dark'];
		
		// draw
		surface.SetDrawColor(
			color.r,
			color.g,
			color.b,
			color.a
		);
		surface.DrawLine(
			22, 4,
			width - 1, 4
		);
		
		// draw bottom half.
		color = AppFramework:Theme().colors['border_light'];
		
		// draw
		surface.SetDrawColor(
			color.r,
			color.g,
			color.b,
			color.a
		);
		surface.DrawLine(
			22, 5,
			width - 1, 5
		);
	
		//
		return;
		
	end
	

	// not hovering.
	if( !self.Hovering ) then return true; end
	
	// calculate color.
	local color = AppFramework:CopyColor( AppFramework:Theme().colors['selection'] );
	
	// calculate delta
	local delta = math.sin( CurTime() * 8 ) * 15;
	
	// adjust color, clamping to the valid range.
	color.r = math.Clamp( color.r + delta, 0, 255 );
	color.g = math.Clamp( color.g + delta, 0, 255 );
	color.b = math.Clamp( color.b + delta, 0, 255 );
	
	// painty!
	surface.SetDrawColor(
		color.r,
		color.g,
		color.b,
		color.a
	);
	surface.DrawRect(
		22, 0,
		width - 22, height
	);
	
	// borders.
	color = AppFramework:Theme().colors['border_light'];
	surface.SetDrawColor(
		color.r,
		color.g,
		color.b,
		color.a
	);
	surface.DrawLine(
		22, 0,
		width - 1, 0
	);
	surface.DrawLine(
		22, height - 1,
		width - 1, height - 1
	);
	surface.DrawLine(
		22, 0,
		22, height
	);
	surface.DrawLine(
		width - 1, 0,
		width - 1, height
	);


	//
	return true;
	
end

// mouse pressed
function PANEL:OnMousePressed( mc )
	// not a submenu?
	if( self.Submenu ) then return; end
	
	// call on parent
	self:GetParent():DoItemClick( self );

end

// on cursor entered/exit
function PANEL:OnCursorEntered( )
	self.Hovering = true;
	
	// do we have a submenu?
	if( self.Submenu && self:GetParent() ) then
		// show submenu.
		self:GetParent():ShowSubMenu( self, self.Submenu );
		
	end
	
	// do we have a submenu?
	if( !self.Submenu && self:GetParent() ) then
		// show submenu.
		self:GetParent():HideSubMenu( );
		
	end
	
	// pass to parent.
	if( self:GetParent() ) then self:GetParent():OnCursorEntered(); end
	
end
function PANEL:OnCursorExited( )
	self.Hovering = false;
	
	// pass to parent.
	if( self:GetParent() ) then self:GetParent():OnCursorExited(); end

end


// 
vgui.Register( "ctl_contextmenuitem", PANEL, "Panel" );

